/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved. See LICENCE file for details.
 */

#include <asm/mmap.h>

	.text
	.global _prolog

_prolog:

	b _rs_init

	/* . = 0x... */

/* word aligned */

_rs_init:

/*
	ldr r0,=(GXEML_CONS_BASE)
	ldr r1,=(_version)
.L1:
	ldrb r2, [r1], #1
	strb r2, [r0]
	cmp r2, #0
	bne .L1
*/

	/* disable exceptions & interrupts */

	/* ... */

	/* ICACHE INIT */

	/* flush and disable instruction cache if enabled */

	/* DCACHE INIT */

	/* flush and disable data cache if enabled */

	/* RELOCATE CODE & DATA */

	/* ... */

	/* binary load in ram at exec location / no need for relocation now */

	/* ZERO BSS/SBSS -- bss and sbss are assumed to be adjacent
	 * and between __bss_start and _end.
	 */

	/* #0bxxxxxxxxxxxx */
	/* fp (r11), ip(r12), sp (r13), lr (r14), pc (r15) */

	/* device id */
	/* mrc p15, 0, r0, c0, c0, 0 */

	ldr r0,=(__bss_start)
	ldr r1,=(_end)
	ldr r2,=(0)
	cmp r0, r1
	beq _1
_0:	ldr r2, [r0], #4
	cmp r0, r1
	bne _0
_1:

	/* JUMP TO RELOC ADDR */

	/* ... */

	/* COPY EXCEPTION ROUTINE(S) */

	/* ... */

	/* STACK INIT */

	ldr sp,=(SYS_INIT_SP)

	/*
	 * Call tiny -- never returns
	 */

	b  tiny

	/* NEVER RETURNS -- but branch to the _prolog just
	 * in case ;-)
	 */
	b  _prolog

	.globl	_version

_version:
	.ascii "TINY"
	.ascii " (", __DATE__, " - ", __TIME__, ")", "\n\0"

