/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved. See LICENCE file for details.
 */

#include <asm/mmap.h>
#include <serial.h>
#include <channel.h>
#include <sysutil.h>

#include <fb.h>
#include <fbcon.h>

void halt(void)
{
	*(unsigned int*)GXEML_HALT_BASE = 0x00;
}

void tiny(void)
{
	channel_init();

	/* configure default channels */

	/* GXemul is very slow when the terminal and the fb output */
    /* are both enabled. Use the debug out (console output) */
    /* only when needed (dbgprintf). */

	fb_init(GXEML_FB_MEM_BASE, 320, 240, 24);
	fbcon_init(320, 240);

	channel_register(STDIN, (channel_handler_t*)cons_getc, \
					(void*)GXEML_CONS_BASE);
	channel_register(STDOUT, (channel_handler_t*)chnl_fbputchar, \
					(void*)0x00);
	channel_register(STDERR, (channel_handler_t*)cons_putc, \
					(void*)GXEML_CONS_BASE);

	printf("tiny arm-eabi [gxemul_experimental_000]\n");

	printf("\npress any key to quit...");
	getchar();

	halt();
}
