/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved. See LICENCE file for details.
 */

#include <asm/mmap.h>

#include <gxfb.h>
#include <string.h>

struct fb {
   unsigned int width;
   unsigned int height;
   unsigned int bpp;
   unsigned int* base;
};

static struct fb mmapfb;

/* in gfx lib */

inline void putpxl(int x, int y, unsigned int argb)
{
   unsigned char* offsc;
   unsigned int* offsi;

   offsc=(unsigned char*)mmapfb.base;
   offsi=(unsigned int*)mmapfb.base;

   switch(mmapfb.bpp)
   {
      case 32:
         offsi[(mmapfb.width * y)+x]=(unsigned int)argb;
         break;
      case 24:
         if(mmapfb.bpp == 24)
         offsc+=((mmapfb.width * 3) * y)+(x*3);
         offsc[0]=(unsigned char)argb & 0xff;
         offsc[1]=(unsigned char)((argb>>8) & 0xff);
         offsc[2]=(unsigned char)((argb>>16) & 0xff);
         break;
   }
}

void fbclear(void)
{
   unsigned int ps;
   unsigned long count;

   ps = (unsigned int)mmapfb.base;

   count = (mmapfb.width * mmapfb.height * (mmapfb.bpp>>3));

   /* alpha channel has to be 0xff on some 32bits framebuffer */
   if(mmapfb.bpp == 32){
      memset_32((void*)ps, 0xff000000, count>>2);
   }else{
      memset((void*)ps, 0x00, count);
   }
}

void fbhscroll(int offset)
{
   unsigned int ps, pe;
   unsigned long count;
   
   ps = (unsigned int)mmapfb.base;

   pe = ps + ((mmapfb.width * offset) * (mmapfb.bpp>>3));
   count = (mmapfb.width * (mmapfb.height - offset)) * (mmapfb.bpp>>3);

   memcpy((void*)ps, (void*)pe, count);

   /* blank last lines */

   ps = (unsigned int)mmapfb.base + (mmapfb.height - offset) * (mmapfb.width * (mmapfb.bpp>>3));

   count = (mmapfb.width * offset) * (mmapfb.bpp>>3);

   /* alpha channel has to be 0xff on some 32bits framebuffer */
   if(mmapfb.bpp == 32){
      memset_32((void*)ps, 0xff000000, count>>2);
   }else{
      memset((void*)ps, 0x00, count);
   }
}

int fb_init(unsigned int base, int width, int height, int bpp)
{
   /* no support for bpp < 8 */
   if(bpp < 8) return -1;

   /* only 24 bpp is supported */
   gxfb_set_mode(width, height);

   mmapfb.base = (unsigned int*)base;
   mmapfb.width = width;
   mmapfb.height = height;
   mmapfb.bpp = bpp;

   return 0;
}

