/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved. See LICENCE file for details.
 */

#include <asm/mmap.h>
#include <gxfb.h>

static void gxfb_set_ctrl_reg(unsigned int reg, unsigned int value)
{
   *(volatile int *)(GXEML_FB_CTRL_BASE + GXEML_FB_CTRL_PORT_OFFSET) = reg;
   *(volatile int *)(GXEML_FB_CTRL_BASE + GXEML_FB_CTRL_DATA_OFFSET) = value;
}

static void gxfb_cmd(unsigned int value)
{
   *(volatile int *)(GXEML_FB_CTRL_BASE + GXEML_FB_CTRL_PORT_OFFSET) = GXEML_FB_CTRL_PORT_CMD;
   *(volatile int *)(GXEML_FB_CTRL_BASE + GXEML_FB_CTRL_DATA_OFFSET) = value;
}

void gxfb_set_mode(unsigned int xres, unsigned int yres)
{
   /* set resolution */
   /* width */
	gxfb_set_ctrl_reg(GXEML_FB_CTRL_PORT_X1, xres);
   /* height */
	gxfb_set_ctrl_reg(GXEML_FB_CTRL_PORT_Y1, yres);
	/* command */
	gxfb_cmd(GXEML_FB_CTRL_CMD_SET_RES);
}
