/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved. See LICENCE file for details.
 */

#ifndef __GXFB_H__
#define __GXFB_H__

#define GXEML_FB_CTRL_PORT_OFFSET	0x00000000
#define GXEML_FB_CTRL_DATA_OFFSET	0x00000010
#define GXEML_FB_CTRL_PORT_CMD  	0x00
#define GXEML_FB_CTRL_PORT_X1  		0x01
#define GXEML_FB_CTRL_PORT_Y1  		0x02
#define	GXEML_FB_CTRL_PORT_X2		0x03
#define	GXEML_FB_CTRL_PORT_Y2		0x04
#define	GXEML_FB_CTRL_PORT_R		0x05
#define	GXEML_FB_CTRL_PORT_G		0x06
#define	GXEML_FB_CTRL_PORT_B		0x07
#define	GXEML_FB_CTRL_PORT_NPORTS	0x08

/* controller commands */

/*  self explicit  */
#define	GXEML_FB_CTRL_CMD_NOP		0x00

/*  set resolution to X1 * Y1.  */
#define	GXEML_FB_CTRL_CMD_SET_RES	0x01

/*  get current resolution into X1, Y1.  */
#define	GXEML_FB_CTRL_CMD_GET_RES	0x02

/*  unimplemented  */
#define	GXEML_FB_CTRL_CMD_FILL		0x03
#define	GXEML_FB_CTRL_CMD_COPY		0x04


#define	DEV_FBCTRL_MAXY(x)	(((DEV_FBCTRL_ADDRESS-DEV_FB_ADDRESS) / 3) / x)

/* ******************* */

extern void gxfb_set_mode(unsigned int xres, unsigned int yres);

#endif /* __GXFB_H__ */

