/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved. See LICENCE file for details.
 */

/* TODO clean this crappy code ;-) */

#include <fb.h>
#include <fbcon.h>
#include <font_8x8.c>

/* 8x8 font */
#define font_w 8
#define font_h 8

struct term {
   int x_max_chr;
   int y_max_chr;
   int cursor_x;
   int cursor_y;
   int cursor_en;
};

static struct term fbterm;

int charblt(int c, int col, int row)
{
	int i,j,k;
   int pix_xoff;
   int pix_yoff;

   pix_xoff = col*font_w;
   pix_yoff = ((row+1)*font_h)-1;

   i=8;
	while(i--)
	{
      j=8; k=7;
      while(j--)
      {
         if ( (*(fontdata_8x8+((c<<3)+i)) >> k--) & 0x01 ) {
            putpxl(pix_xoff, pix_yoff, (unsigned int)0xffffffff);
         }else{
            putpxl(pix_xoff, pix_yoff, (unsigned int)0xff000000);
         }
         pix_xoff++;
      }
      pix_xoff-=font_w;
      pix_yoff--;
	}
 
  return 0;
}

/* compatible with channel_handler_t */
int chnl_fbputchar(int reserved, int c)
{
	return fbputchar(c);
}

int fbputchar(int c)
{
   /* special char / TODO replace by real term emulation */

//   fbterm.cursor_en = 1;
   
   switch(c){
      case '\r':
         fbterm.cursor_x = 0;
         charblt(0x00, fbterm.cursor_x, fbterm.cursor_y);   /* cursor */
         break;
      case '\n':
         charblt(0x00, fbterm.cursor_x, fbterm.cursor_y);   /* cursor */
         fbterm.cursor_x = 0;
         fbterm.cursor_y++;
         break;
      default:
         charblt(c, fbterm.cursor_x++, fbterm.cursor_y);
         break;
   }

   /* check for borders */

   if (fbterm.cursor_x == fbterm.x_max_chr) {
      fbterm.cursor_x = 0;
      fbterm.cursor_y++;      
   }

   if (fbterm.cursor_y == fbterm.y_max_chr) {
      fbhscroll(font_h);
      fbterm.cursor_y--;
   }

   // charblt(0xdb, fbterm.cursor_x, fbterm.cursor_y);   /* cursor */

//   fbterm.cursor_en = 0;

   return (int)c;
}

int fbputs(char* str)
{
	int i=0;

	while(str[i])
	{
		/* charblt(str[i], fbterm.cursor_x++, fbterm.cursor_y); */
      fbputchar(str[i]);
      i++; /* if (i>80) break; */
	}
   
	return 0;
}

int fbcon_init(int width, int height)
{
   /* TODO check if width/height are ok */

   fbterm.x_max_chr = width / font_w;
   fbterm.y_max_chr = height / font_h;

   fbterm.cursor_x = 0;
   fbterm.cursor_y = 0;
   fbterm.cursor_en = 0;

   return 0;
}

