/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved. See LICENCE file for details.
 */

#ifndef __MMAP_H__
#define __MMAP_H__

/************************************************************/

/* cpu */

/* change with arm_xxx core values */

#define CPU_ICACHE_SIZE       16384       /* 16 KByte total	*/
#define CPU_ICACHELINE_SIZE   xx          /* xx bytes/line	*/

#define CPU_DCACHE_SIZE       16384       /* 16 KByte */
#define CPU_DCACHELINE_SIZE   xx          /* xx bytes/line */

#define SYS_EXCEPTION_ADDR    0xXXXXXXXX  /* Exception entry point */

#define SYS_INIT_SP           0x01f00000

/************************************************************/

/* memories */

#define MEM_NOR_FLASH_BASE    0xXXXXXXXX  /* FLASH base addr */
#define MEM_NOR_FLASH_SIZE    0xXXXXXXXX  /* xx MByte */
#define MEM_DRAM_BASE         0x00000000  /* DRAM base addr */
#define MEM_DRAM_SIZE         0x02000000  /* 32 MByte */
#define MEM_SRAM_BASE         0xXXXXXXXX  /* SRAM base addr */
#define MEM_SRAM_SIZE         0xXXXXXXXX  /* xx kBytes */

/************************************************************/

/* peripherals */

#define GXEML_CONS_BASE       0x10000000

#define GXEML_HALT_BASE       0x10000010

#define GXEML_FB_MEM_BASE			0x12000000
#define GXEML_FB_CTRL_BASE			0x12f00000

/* graphics */

#define MEM_GFX_P1_BASE       0x02000000  /* xxx*xxx*xxbpp */
#define MEM_GFX_P2_BASE       0xXXXXXXXX  /* xxx*xxx*xxbpp */
#define MEM_GFX_P3_BASE       0xXXXXXXXX  /* xxx*xxx*xxbpp */

/************************************************************/

/* console */

#define IO_DFLT_XXX           0xXXXXXXXX

#endif   /* __MMAP_H__ */
 
