/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved. See LICENCE file for details.
 */

#ifndef __VT100_H__
#define __VT100_H__

/*
 * this is what the terminal answers to a ESC-Z or csi0c query.
 */

#define VT100ID "\033[?1;2c"
#define VT102ID "\033[?6c"

/* VT100 : terminal setup */

#define VT_RESET           "\033c"             /* Reset all terminal settings to default */

/* VT100 : screen operations */

#define VT_CLEARSCR        "\x1B[2J\x1B[;H"    /* Clear SCReen */
#define VT_CLEAREOL        "\x1B[K"            /* Clear End Of Line */
#define VT_CLEAREOS        "\x1B[J"            /* Clear End Of Screen */
#define VT_CLEARLCR        "\x1B[0K"           /* Clear Line Cursor Right */
#define VT_CLEARLCL        "\x1B[1K"           /* Clear Line Cursor Left */
#define VT_CLEARELN        "\x1B[2K"           /* Clear Entire LiNe */
#define VT_CLEARCDW        "\x1B[0J"           /* Clear Curseur DoWn */
#define VT_CLEARCUP        "\x1B[1J"           /* Clear Curseur UP */
#define VT_GOTO(X,Y)       "\x1B[%d;%dH", X, Y /* Goto (y,x) */

#define VT_INSERTMOD       "\x1B[4h"           /* insert */
#define VT_OVERWRITEMOD    "\x1B[4l"           /* overwrite */
#define VT_DELAFCURSOR     "\x1B[K"
#define VT_CRLF            "\r\n"              /* carriage return + line feed */

/* VT100 : cursor operations */

#define VT_CURSON          "\x1B[?25h"         /* cursor visible */
#define VT_CURSOFF         "\x1B[?25l"         /* cursor invisible */

/* VT100 : text operations */

#define VT_NORMAL          "\x1B[0m"           /* normal */
#define VT_BOLD            "\x1B[1m"           /* bold */
#define VT_UNDERLINE       "\x1B[4m"           /* underline */
#define VT_BLINKING        "\x1B[5m"           /* blinking */
#define VT_INVVIDEO        "\x1B[7m"           /* inverted video */

/* VT100 : colors */

#define VT_CL_BLACK        "\033[22;30m"       /* black */
#define VT_CL_RED          "\033[22;31m"       /* red */
#define VT_CL_GREEN        "\033[22;32m"       /* green */
#define VT_CL_BROWN        "\033[22;33m"       /* brown */
#define VT_CL_BLUE         "\033[22;34m"       /* blue */
#define VT_CL_MAGENTA      "\033[22;35m"       /* magenta */
#define VT_CL_CYAN         "\033[22;36m"       /* cyan */
#define VT_CL_GRAY         "\033[22;37m"       /* gray */
#define VT_CL_DARKGRAY     "\033[01;30m"       /* dark gray */
#define VT_CL_LIGHTRED     "\033[01;31m"       /* light red */
#define VT_CL_LIGHTGREEN   "\033[01;32m"       /* light green */
#define VT_CL_YELLOW       "\033[01;33m"       /* yellow */
#define VT_CL_LIGHTBLUE    "\033[01;34m"       /* light blue */
#define VT_CL_LIGHTMAGENTA "\033[01;35m"       /* light magenta */
#define VT_CL_LIGHTCYAN    "\033[01;36m"       /* light cian */
#define VT_CL_WHITE        "\033[01;37m"       /* light white */

#endif /* __VT100_H__ */

