/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of this project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND THE CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <channel.h>

struct channel_dsc {
   channel_handler_t *handler;
   void *arg_0;
   int enable;
   long count;
};

static struct channel_dsc channel[32];

static void channel_def_hdlr(void)
{
	/*do nothing */
}

void channel_init(void)
{
	int i;

	/* Assign the default handler to all */
	for (i = 0; i < 32; i++) {
		channel[i].handler = (channel_handler_t*)channel_def_hdlr;
		channel[i].arg_0 = (void *)i;
		channel[i].enable = 0;
		channel[i].count = 0;
	}
}

void channel_register(int chnl, channel_handler_t *hdlr, void *arg_0)
{
	static struct channel_dsc* dsc;
	dsc = &channel[chnl];
	
	if ((chnl < 0) || (chnl > 31))
		return;

	if (hdlr) {
		dsc->handler = hdlr;
		dsc->arg_0 = arg_0;
		dsc->enable = 1;	/* enable */
		dsc->count = 0;
	} else {
		dsc->handler = (channel_handler_t*)channel_def_hdlr;
		dsc->arg_0 = (void *)chnl;	/* ... */
		dsc->enable = 0;	/* disable */
		dsc->count = 0;
	}
}

void* channel_io(int chnl, void* arg_1)
{
	static struct channel_dsc* dsc;
	void* val;
	dsc = &channel[chnl];

	val = dsc->handler (dsc->arg_0, arg_1);
	dsc->count++;

	return val;
}

void channel_info(void)
{
	/* ... */
}
