/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of this project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND THE CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stddef.h>

void *memcpy(void *s1, const void *s2, size_t n)
{
   unsigned char *d = (unsigned char *)s1;
   unsigned char *s = (unsigned char *)s2;

	while (n--) *d++ = *s++;

	return s1;
}

void *memset(void *s, int c, size_t n)
{
   unsigned char *d = (unsigned char *)s;

	while (n--) *d++ = (unsigned char)c;

	return s;
}

void *memset_32(void *s, int u, size_t n)
{
   if((int)s%4) return 0;
   
   unsigned int *ms = (unsigned int *) s;

   while (n--)
		*ms++ = u;

	return s;
}

size_t strlen(const char *s)
{
   const char *sc = s;

   if(!s) return 0;
   
   while(*sc) ++sc;

   return (size_t)(sc - s);
}

size_t strnlen(const char *s, size_t maxlen)
{
   const char *sc = s;

   if(!s) return 0;

   while(*sc && maxlen--) ++sc;

   return (size_t)(sc - s);
}

