/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of this project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND THE CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdarg.h>
#include <sysutil.h>

#include <channel.h>

#include <asm/mmap.h>	/* temporary => MEM_IMMR | IO_PSC3_OFFSET*/

int getchar(void)
{
   return (int)channel_io(STDIN, (void*)0x00);
}

int putchar(char c)
{
   channel_io(STDOUT, (void*)(int)c);
   /* return is an unsigned char cast to an int or EOF on error. */
   return (int)c;
}

void putc(char c)
{
   channel_io(STDOUT, (void*)(int)c);
}

void puts (char* s)
{
   while(*s) putc(*s++);
}

void printf (const char *fmt, ...)
{
   static char buf[1024];

   va_list args;

   va_start (args, fmt);

   vsprintf(buf, fmt, args);

   va_end (args);

   puts(buf);
}

void dbgprintf (const char *fmt, ...)
{
   static char buf[1024];
   char *s = buf;

   va_list args;

   va_start (args, fmt);

   vsprintf(buf, fmt, args);

   va_end (args);

   while(*s) channel_io(STDERR, (void*)(int)(*s++));
}
