/*
 * Copyright (c) 2008, Noel Lemouel
 * All rights reserved. See LICENCE file for details.
 */

OUTPUT_ARCH(arm)
ENTRY(_prolog)

SECTIONS
{
	PROVIDE (__executable_start = 0x00008000);
	.text :
	{
      asm_arm/entry.o (.text)
	  *(.text)
	  *(.text.*)
	  *(.gnu.linkonce.t*)
	  *(.rodata)
	  *(.rodata.*)
	  *(.gnu.linkonce.r*)
	}
	. = ALIGN (4);
	_etext = .;
	PROVIDE (etext = .);

	/* INIT DATA sections - "Small" data (see the gcc -G option)
	 * is always gp-relative. Here we make all init data sections
	 * adjacent to simplify the startup code -- and provide
	 * the global pointer for gp-relative access.
	 */
	_data = .;
	.data :
	{
	  *(.data)
	  *(.data.*)
	  *(.gnu.linkonce.d*)
	}

	. = ALIGN(32);		/* e300cx data cache line size */

	/* no Small Data Area at the moment
	 * .sdata / .sbss 
	 * PPC.EMB.sdata2 / .PPC.EMB.sbss2
	 * .got
	 * sections not used
	 */
/*
 *	_sda = .;
 *	PROVIDE (sda = .);
 *
 *	.sdata :
 *	{
 *	  *(.sdata)
 *	  *(.sdata.*)
 *	  *(.gnu.linkonce.s.*)
 *	}
 *	. = ALIGN(4);
 *
 *	_edata = .;
 *	PROVIDE (edata = .);
 */ 
	/* UNINIT DATA */
	__bss_start = .;
/*	.sbss :
 *	{
 *	  *(.sbss)
 *	  *(.sbss.*)
 *	  *(.gnu.linkonce.sb.*)
 *	  *(.scommon)
 *	}
 *	. = ALIGN(4);
 */
	.bss :
	{
	  *(.bss)
	  *(.bss.*)
	  *(.dynbss)
	  *(COMMON)
	  *(.scommon)
	}
	. = ALIGN(4);
	_end = .;
/*	PROVIDE (end = .); */

	/* DEBUG */

	.stab 0 : { *(.stab) }
	.stabstr 0 : { *(.stabstr) }
	.stab.excl 0 : { *(.stab.excl) }
	.stab.exclstr 0 : { *(.stab.exclstr) }
	.stab.index 0 : { *(.stab.index) }
	.stab.indexstr 0 : { *(.stab.indexstr) }

	.comment 0 : { *(.comment) }

	.debug		0 : { *(.debug) }
	.line		0 : { *(.line) }
	.debug_srcinfo	0 : { *(.debug_srcinfo) }
	.debug_sfnames	0 : { *(.debug_sfnames) }
	.debug_aranges	0 : { *(.debug_aranges) }
	.debug_pubnames 0 : { *(.debug_pubnames) }
	.debug_info	0 : { *(.debug_info) }
	.debug_abbrev	0 : { *(.debug_abbrev) }
	.debug_line	0 : { *(.debug_line) }
	.debug_frame	0 : { *(.debug_frame) }
	.debug_str	0 : { *(.debug_str) }
	.debug_loc	0 : { *(.debug_loc) }
	.debug_macinfo	0 : { *(.debug_macinfo) }
	.debug_weaknames 0 : { *(.debug_weaknames) }
	.debug_funcnames 0 : { *(.debug_funcnames) }
	.debug_typenames 0 : { *(.debug_typenames) }
	.debug_varnames	 0 : { *(.debug_varnames) }

}
